package furny.ga.test;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.logging.Logger;

import furny.entities.Furniture;
import furny.furndb.FurnCache;
import furny.ga.util.FurnitureUtil;

public final class TestRouletteMutation {

  // the logger for this class
  private static final Logger LOGGER = Logger
      .getLogger(TestRouletteMutation.class.getName());

  private static NumberFormat format = new DecimalFormat("0.00");

  private TestRouletteMutation() {
  }

  public static void main(final String[] args) {
    final Furniture furn = FurnCache.getInstance().getAllFurnitures().get(0);

    LOGGER.info("\n Similarity probability for " + furn);

    LOGGER.info("\n");
    for (int i = 0; i < 10; i++) {
      // LOGGER
      // .info("\n Mutated furn: "
      // + FurnitureUtil.getOtherFurnitureBySimilarityRoulette(furn)
      // .getName());

      LOGGER.info("\n Mutated furn: "
          + FurnitureUtil.getOtherFurnitureBySimilarityDistance(furn, 2));
    }
  }

  private static void checkSimilarity(final Furniture f1, final Furniture f2) {
    final double f = FurnitureUtil.getSimilarity(f1, f2);

    LOGGER.info(format.format(f) + "  " + f1 + " / " + f2);
  }
}
